#!/usr/bin/env python3
"""
Update stage_management to use send_location action in payment stage
"""

from supabase import create_client
from dotenv import load_dotenv
import os

load_dotenv()

supabase = create_client(os.getenv('SUPABASE_URL'), os.getenv('SUPABASE_KEY'))

# Get current stage_management
result = supabase.table('prompt_sections').select('*').eq('section_key', 'stage_management').execute()

if not result.data:
    print("❌ stage_management not found")
    exit(1)

current_content = result.data[0]['content']

# Add instruction for payment stage
payment_instruction = """
### 📍 إرسال Location في مرحلة payment:
- **إذا كان stage = 'payment' وسأل العميل عن طلبه** (مثل "ما طلبي"، "what's my order"):
  - استخدم `action: "send_location"` لإرسال Location Message
  - ثم أرسل تفاصيل الطلب في الـ reply
  - مثال:
    ```json
    {
      "intent": "Ask Information",
      "reply": "طلبك الحالي هو:\\n\\n📋 ملخص طلبك:\\n• 1 × هريس لحم (2.800 ر.ع) = 2.800 ر.ع\\n\\n💰 المجموع الفرعي: 2.800 ر.ع\\n📍 العنوان: موقع جغرافي\\n\\nما هي طريقة الدفع التي تفضلها؟ (نقدي أو بطاقة)",
      "action": "send_location",
      "data": null
    }
    ```
"""

# Find the payment stage section and add instruction
lines = current_content.split('\n')
new_lines = []
payment_section_found = False

for i, line in enumerate(lines):
    new_lines.append(line)
    
    # Add after "2. **إذا كان stage = 'payment'**:"
    if '**إذا كان stage = \'payment\'**' in line and not payment_section_found:
        # Add the instruction after the next 2 lines
        new_lines.append(lines[i+1] if i+1 < len(lines) else '')
        new_lines.append(lines[i+2] if i+2 < len(lines) else '')
        new_lines.append(payment_instruction)
        payment_section_found = True
        # Skip the next 2 lines since we already added them
        i += 2

new_content = '\n'.join(new_lines)

# Update the prompt
supabase.table('prompt_sections').update({
    'content': new_content
}).eq('section_key', 'stage_management').execute()

print("✅ Updated stage_management with send_location instruction")

