#!/usr/bin/env python3
"""
Update intent_new_order_items prompt to include delivery fee in order summary
"""

import os
import sys
from pathlib import Path

# Add parent directory to path
sys.path.insert(0, str(Path(__file__).parent.parent))

from supabase import create_client
from app.config import settings

def main():
    """Update the intent_new_order_items prompt section"""
    
    # Create Supabase client
    supabase = create_client(settings.SUPABASE_URL, settings.SUPABASE_KEY)
    
    # New content with delivery fee included
    new_content = """### 8. New Order - Items
- **متى**: بدء طلب جديد أو إضافة أصناف
- **أمثلة بالعربية**: "أريد هريس"، "أضف كبسة"، "2 عرسي جعلان و 3 سلطة"
- **أمثلة بالإنجليزية**: "I want harees", "Add kabsa", "2 arsi jalan and 3 salad"
- **⚠️ مهم جداً**: يجب استخراج **code** و **name** و **price** من قاعدة بيانات المنيو بالضبط!
- **⚠️ قاعدة حاسمة**: يجب أن يكون الـ code موجود في قاعدة بيانات المنيو. إذا لم تجد الصنف بالضبط، ابحث عن أقرب تطابق.
- **الاستخراج**:
  - items: [{"code": "HAREES_MEAT", "name": "هريس لحم", "quantity": 1, "price": 2.800, "notes": ""}]
  - subtotal: مجموع (quantity × price) لكل الأصناف
- **⚠️ قاعدة مهمة للـ stage**:
  - **إذا قال العميل "جاهز" أو "خلاص" أو "أكمل" أو "هذا كل شيء" أو "أعطيني عنوانك"** → غير stage إلى "address" واطلب العنوان
  - **خلاف ذلك** → ابق في stage = "items" ودع العميل يضيف المزيد
- **الرد بالعربية (إذا أضاف صنف فقط)**: "تم إضافة [items].

📋 ملخص طلبك:
[قائمة الأصناف مع الكميات والأسعار بالتفصيل]

💰 المجموع الفرعي: [subtotal] ر.ع
🚚 رسوم التوصيل: 0.500 ر.ع
💵 الإجمالي: [subtotal + 0.500] ر.ع

هل ترغب في إضافة المزيد أم تعطيني عنوانك؟"
- **الرد بالعربية (إذا قال جاهز/خلاص)**: "تمام! 👍

📋 ملخص طلبك:
[قائمة الأصناف مع الكميات والأسعار بالتفصيل]

💰 المجموع الفرعي: [subtotal] ر.ع
🚚 رسوم التوصيل: 0.500 ر.ع
💵 الإجمالي: [subtotal + 0.500] ر.ع

من فضلك أعطني عنوانك للتوصيل 📍
مثال: شارع السويق، مبنى 15
أو أرسل موقعك الجغرافي من WhatsApp"
- **الرد بالإنجليزية (إذا أضاف صنف فقط)**: "Added [items].

📋 Your order summary:
[detailed list of items with quantities and prices]

💰 Subtotal: [subtotal] OMR
🚚 Delivery Fee: 0.500 OMR
💵 Total: [subtotal + 0.500] OMR

Would you like to add more or give me your address?"
- **الرد بالإنجليزية (إذا قال ready/done)**: "Great! 👍

📋 Your order summary:
[detailed list of items with quantities and prices]

💰 Subtotal: [subtotal] OMR
🚚 Delivery Fee: 0.500 OMR
💵 Total: [subtotal + 0.500] OMR

Please give me your delivery address 📍
Example: Al Khuwair, Building 123
Or send your location from WhatsApp"
- **action**: "update_session"
- **data (إذا أضاف صنف فقط)**: {"stage": "items", "items": [...], "subtotal": ...}
- **data (إذا قال جاهز/خلاص)**: {"stage": "address", "items": [...], "subtotal": ...}

**⚠️ ملاحظات مهمة**:
1. **رسوم التوصيل ثابتة**: 0.500 ر.ع (يجب إضافتها دائماً في الملخص)
2. **الإجمالي = المجموع الفرعي + رسوم التوصيل**
3. **عند عرض الملخص**: يجب أن تظهر 3 أسطر:
   - المجموع الفرعي (مجموع الأصناف فقط)
   - رسوم التوصيل (0.500 ر.ع)
   - الإجمالي (المجموع الفرعي + رسوم التوصيل)

**مثال كامل بالعربية**:
```
تم إضافة هريس لحم × 1 ✅

📋 ملخص طلبك:
• 1 × هريس لحم (2.800 ر.ع للوحدة) = 2.800 ر.ع

💰 المجموع الفرعي: 2.800 ر.ع
🚚 رسوم التوصيل: 0.500 ر.ع
💵 الإجمالي: 3.300 ر.ع

هل ترغب في إضافة المزيد أم تعطيني عنوانك؟
```

**مثال كامل بالإنجليزية**:
```
Added 1 × Harees Meat ✅

📋 Your order summary:
• 1 × Harees Meat (2.800 OMR each) = 2.800 OMR

💰 Subtotal: 2.800 OMR
🚚 Delivery Fee: 0.500 OMR
💵 Total: 3.300 OMR

Would you like to add more or give me your address?
```"""
    
    try:
        # Update the section
        response = supabase.table('prompt_sections') \
            .update({'content': new_content}) \
            .eq('section_key', 'intent_new_order_items') \
            .execute()
        
        if response.data:
            print('✅ Successfully updated intent_new_order_items prompt section')
            print('📋 Changes:')
            print('   - Added delivery fee (0.500 OMR) to order summary')
            print('   - Added total line (subtotal + delivery fee)')
            print('   - Updated both Arabic and English responses')
            print('   - Added detailed examples')
        else:
            print('❌ Failed to update prompt section')
            
    except Exception as e:
        print(f'❌ Error updating prompt section: {e}')
        return 1
    
    return 0

if __name__ == '__main__':
    sys.exit(main())

