#!/usr/bin/env python3
"""
Update prompt to ask for location instead of address
"""

import os
import sys
from supabase import create_client, Client
from dotenv import load_dotenv

# Load environment variables
load_dotenv()

def main():
    # Initialize Supabase client
    supabase_url = os.getenv('SUPABASE_URL')
    supabase_key = os.getenv('SUPABASE_KEY')
    
    if not supabase_url or not supabase_key:
        print('❌ Error: SUPABASE_URL and SUPABASE_KEY must be set in .env')
        return 1
    
    supabase: Client = create_client(supabase_url, supabase_key)
    
    # New content for intent_new_order_items
    new_content = """### 8. New Order - Items
- **متى**: إضافة أصناف للطلب (stage = 'items' أو فارغ)
- **أمثلة بالعربية**: "أريد هريس"، "أضف كبسة"، "2 شوربة"
- **أمثلة بالإنجليزية**: "I want harees", "Add kabsa", "2 soups"
- **الاستخراج**:
  - items: [{"name": "هريس لحم", "name_en": "Harees Meat", "code": "HAREES_MEAT", "qty": 1, "price": 2.800}]
  - subtotal: 2.800 (مجموع الأسعار)
- **الرد بالعربية (إذا أضاف صنف فقط)**: "تم إضافة [items].

📋 ملخص طلبك:
[قائمة الأصناف مع الكميات والأسعار بالتفصيل]

💰 المجموع الفرعي: [subtotal] ر.ع
🚚 رسوم التوصيل: 0.500 ر.ع
💵 الإجمالي: [subtotal + 0.500] ر.ع

هل ترغب في إضافة المزيد أم ترسل موقعك؟ 📍"
- **الرد بالعربية (إذا قال جاهز/خلاص)**: "تمام! 👍

📋 ملخص طلبك:
[قائمة الأصناف مع الكميات والأسعار بالتفصيل]

💰 المجموع الفرعي: [subtotal] ر.ع
🚚 رسوم التوصيل: 0.500 ر.ع
💵 الإجمالي: [subtotal + 0.500] ر.ع

من فضلك أرسل موقعك الجغرافي من WhatsApp 📍
أو اكتب عنوانك نصاً
مثال: شارع السويق، مبنى 15"
- **الرد بالإنجليزية (إذا أضاف صنف فقط)**: "Added [items].

📋 Your order summary:
[detailed list of items with quantities and prices]

💰 Subtotal: [subtotal] OMR
🚚 Delivery Fee: 0.500 OMR
💵 Total: [subtotal + 0.500] OMR

Would you like to add more or send your location? 📍"
- **الرد بالإنجليزية (إذا قال ready/done)**: "Great! 👍

📋 Your order summary:
[detailed list of items with quantities and prices]

💰 Subtotal: [subtotal] OMR
🚚 Delivery Fee: 0.500 OMR
💵 Total: [subtotal + 0.500] OMR

Please send your location from WhatsApp 📍
Or type your address as text
Example: Al Khuwair, Building 123"
- **action**: "update_session"
- **data (إذا أضاف صنف فقط)**: {"stage": "items", "items": [...], "subtotal": ...}
- **data (إذا قال جاهز/خلاص)**: {"stage": "address", "items": [...], "subtotal": ...}

**⚠️ ملاحظات مهمة**:
1. **رسوم التوصيل ثابتة**: 0.500 ر.ع (يجب إضافتها دائماً في الملخص)
2. **الإجمالي = المجموع الفرعي + رسوم التوصيل**
3. **عند عرض الملخص**: يجب أن تظهر 3 أسطر:
   - المجموع الفرعي (مجموع الأصناف فقط)
   - رسوم التوصيل (0.500 ر.ع)
   - الإجمالي (المجموع الفرعي + رسوم التوصيل)
4. **طلب الموقع**: اطلب "أرسل موقعك" بدلاً من "أعطني عنوانك"

**مثال كامل بالعربية**:
```
تم إضافة هريس لحم × 1 ✅

📋 ملخص طلبك:
• 1 × هريس لحم (2.800 ر.ع للوحدة) = 2.800 ر.ع

💰 المجموع الفرعي: 2.800 ر.ع
🚚 رسوم التوصيل: 0.500 ر.ع
💵 الإجمالي: 3.300 ر.ع

هل ترغب في إضافة المزيد أم ترسل موقعك؟ 📍
```

**مثال كامل بالإنجليزية**:
```
Added 1 × Harees Meat ✅

📋 Your order summary:
• 1 × Harees Meat (2.800 OMR each) = 2.800 OMR

💰 Subtotal: 2.800 OMR
🚚 Delivery Fee: 0.500 OMR
💵 Total: 3.300 OMR

Would you like to add more or send your location? 📍
```"""
    
    try:
        # Update the section
        response = supabase.table('prompt_sections') \
            .update({'content': new_content}) \
            .eq('section_key', 'intent_new_order_items') \
            .execute()
        
        if response.data:
            print('✅ Successfully updated intent_new_order_items prompt section')
            print('📋 Changes:')
            print('   - Changed "give me your address" to "send your location"')
            print('   - Updated both Arabic and English responses')
            print('   - Added option to send location OR type address')
        else:
            print('❌ Failed to update prompt section')
            
    except Exception as e:
        print(f'❌ Error updating prompt section: {e}')
        return 1
    
    return 0

if __name__ == '__main__':
    sys.exit(main())

