#!/usr/bin/env python3
"""
Test Live Search - اختبار البحث المباشر
"""

import os
import sys
from dotenv import load_dotenv

# Load environment variables
load_dotenv()

# Add parent directory to path
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from app.services.menu_search_service import menu_search_service

def test_search(query: str):
    """Test search and display results"""
    result = menu_search_service.search_menu(query, limit=5)
    
    print('\n' + '='*80)
    print(f'🔍 البحث عن: "{query}"')
    print('='*80 + '\n')
    
    print('📊 النتائج:')
    print(f'   - إجمالي النتائج: {result["total_found"]}')
    print(f'   - طرق البحث: {", ".join(result["search_methods"])}')
    print(f'   - Exact: {result["exact_count"]}, Partial: {result["partial_count"]}, Semantic: {result["semantic_count"]}')
    
    if result['results']:
        print('\n📋 الأصناف المتاحة:\n')
        for i, item in enumerate(result['results'], 1):
            name_ar = item['name_ar']
            name_en = item.get('name_en', 'N/A')
            price = item.get('price', 0)
            category = item.get('category', 'N/A')
            match_type = item.get('match_type', 'N/A')
            match_score = item.get('match_score', 0)
            
            print(f'{i}. {name_ar}')
            print(f'   English: {name_en}')
            print(f'   Price: {price} ر.ع')
            print(f'   Category: {category}')
            print(f'   Match: {match_type} (score={match_score:.2f})')
            print()
    else:
        print('\n❌ لم يتم العثور على نتائج')
    
    print('='*80 + '\n')
    
    return result

if __name__ == "__main__":
    # Test the query
    query = "هريس"
    test_search(query)

