#!/bin/bash
# -*- coding: utf-8 -*-
#
# سكريبت تشغيل تحليلات الأسبوع الأول
# يقوم بتشغيل جميع أدوات التحليل والتقييم
#

echo "🚀 بدء تحليلات الأسبوع الأول - التحضير والتقييم"
echo "============================================================"
echo ""

# التحقق من وجود Python
if ! command -v python3 &> /dev/null; then
    echo "❌ Python 3 غير مثبت"
    exit 1
fi

echo "✅ Python 3 موجود"
echo ""

# إنشاء المجلدات المطلوبة
echo "📁 إنشاء المجلدات..."
mkdir -p analysis
mkdir -p metrics
mkdir -p reports
mkdir -p scripts/analysis
mkdir -p scripts/improvement
mkdir -p tests/unit
mkdir -p tests/integration
mkdir -p tests/data

echo "✅ تم إنشاء المجلدات"
echo ""

# التحقق من وجود ملف اللوقات
if [ ! -f "logs/app.log" ]; then
    echo "⚠️  ملف اللوقات غير موجود: logs/app.log"
    echo "💡 سيتم إنشاء تقارير فارغة"
    echo ""
fi

# 1. استخراج رسائل المستخدمين
echo "============================================================"
echo "📊 الخطوة 1/3: استخراج رسائل المستخدمين"
echo "============================================================"
echo ""

python3 scripts/analysis/extract_user_messages.py

if [ $? -eq 0 ]; then
    echo ""
    echo "✅ اكتمل استخراج الرسائل"
else
    echo ""
    echo "❌ فشل استخراج الرسائل"
fi

echo ""
echo "اضغط Enter للمتابعة..."
read

# 2. تحليل الأخطاء
echo ""
echo "============================================================"
echo "📊 الخطوة 2/3: تحليل الأخطاء"
echo "============================================================"
echo ""

python3 scripts/analysis/analyze_errors.py

if [ $? -eq 0 ]; then
    echo ""
    echo "✅ اكتمل تحليل الأخطاء"
else
    echo ""
    echo "❌ فشل تحليل الأخطاء"
fi

echo ""
echo "اضغط Enter للمتابعة..."
read

# 3. حساب المقاييس الأساسية
echo ""
echo "============================================================"
echo "📊 الخطوة 3/3: حساب المقاييس الأساسية"
echo "============================================================"
echo ""

python3 scripts/analysis/calculate_baseline.py

if [ $? -eq 0 ]; then
    echo ""
    echo "✅ اكتمل حساب المقاييس"
else
    echo ""
    echo "❌ فشل حساب المقاييس"
fi

echo ""
echo "============================================================"
echo "✅ اكتملت جميع التحليلات!"
echo "============================================================"
echo ""

# عرض ملخص الملفات المنشأة
echo "📄 الملفات المنشأة:"
echo ""

if [ -f "analysis/user_messages_report.json" ]; then
    echo "   ✅ analysis/user_messages_report.json"
    echo "   ✅ analysis/user_messages.txt"
    echo "   ✅ analysis/top_words.txt"
fi

if [ -f "analysis/error_report.json" ]; then
    echo "   ✅ analysis/error_report.json"
    echo "   ✅ analysis/top_failed_queries.txt"
fi

if [ -f "metrics/baseline.json" ]; then
    echo "   ✅ metrics/baseline.json"
fi

echo ""
echo "============================================================"
echo "📋 الخطوات التالية:"
echo "============================================================"
echo ""
echo "1. راجع التقارير في مجلد analysis/"
echo "2. راجع المقاييس الأساسية في metrics/baseline.json"
echo "3. حدد الأولويات بناءً على التحليل"
echo "4. ابدأ بالأسبوع الثاني: توحيد النصوص"
echo ""
echo "💡 لعرض ملخص سريع، شغّل:"
echo "   cat analysis/error_report.json | python3 -m json.tool"
echo "   cat metrics/baseline.json | python3 -m json.tool"
echo ""
echo "🎉 بالتوفيق!"
echo ""

