#!/usr/bin/env python3
"""
تحسين اكتشاف النوايا - التمييز بين الاستفسار والطلب
"""

import os
import sys
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from supabase import create_client
from dotenv import load_dotenv

load_dotenv()

supabase = create_client(
    os.getenv('SUPABASE_URL'),
    os.getenv('SUPABASE_KEY')
)

print("="*70)
print("تحسين اكتشاف النوايا")
print("="*70)

# 1. Update Ask Information Intent
print("\n1️⃣ تحديث نية Ask Information...")

ask_info_update = """
**Ask Information (استفسار عن معلومات)**

**متى تستخدم هذه النية:**
- عندما يسأل العميل عن **توفر** صنف: "عندكم هريس؟"، "هل يوجد كبسة؟"
- عندما يسأل عن **سعر** صنف: "كم سعر الهريس؟"، "بكم الكبسة؟"
- عندما يسأل عن **وصف** صنف: "ما هو الهريس؟"، "شو الكبسة؟"
- عندما يسأل عن **معلومات عامة**: "عندكم توصيل؟"، "كم رسوم التوصيل؟"

**الكلمات المفتاحية للاستفسار:**
- "عندكم"، "هل يوجد"، "هل عندكم"، "فيه"
- "كم سعر"، "بكم"، "كم ثمن"، "كم يكلف"
- "ما هو"، "شو"، "وش"، "ايش"
- "معلومات عن"، "أخبرني عن"

**أمثلة:**
- "عندكم هريس؟" → استفسار (رد: نعم، عندنا هريس لحم بسعر 2.800 ر.ع)
- "كم سعر الكبسة؟" → استفسار (رد: كبسة دجاج 3.500 ر.ع)
- "ما هو الهريس؟" → استفسار (رد: الهريس طبق عماني تقليدي...)

**⚠️ لا تستخدم هذه النية إذا:**
- العميل يريد **إضافة** صنف: "أريد هريس"، "أضف كبسة"
- العميل يريد **طلب**: "بغيت هريس"، "طيب أريد 2 هريس"

**الرد:**
- أجب على السؤال بوضوح
- أعطِ المعلومات المطلوبة فقط
- لا تضف الصنف للطلب
- اسأل إذا كان يريد طلبه بعد إعطاء المعلومات
"""

result = supabase.table('prompt_sections').update({
    'content': ask_info_update
}).eq('section_key', 'intent_ask_information').execute()

if result.data:
    print("✅ تم تحديث Ask Information")
else:
    print("❌ فشل تحديث Ask Information")

# 2. Update New Order Items Intent
print("\n2️⃣ تحديث نية New Order - Items...")

new_order_items_update = """
**New Order - Items (إضافة أصناف للطلب)**

**متى تستخدم هذه النية:**
- عندما يريد العميل **إضافة** صنف: "أريد هريس"، "أضف كبسة"
- عندما يريد العميل **طلب** صنف: "بغيت هريس"، "طيب أريد 2 هريس"
- عندما يحدد **كمية**: "2 هريس لحم"، "3 كبسة دجاج"

**الكلمات المفتاحية للطلب:**
- "أريد"، "بغيت"، "أبغى"، "أبي"
- "أضف"، "زيد"، "حط"
- "طيب أريد"، "خلاص أريد"، "ماشي أريد"
- أرقام + اسم صنف: "2 هريس"، "3 كبسة"

**أمثلة:**
- "أريد هريس" → طلب (أضف 1 هريس لحم)
- "أضف كبسة دجاج" → طلب (أضف 1 كبسة دجاج)
- "طيب أريد 2 هريس لحم" → طلب (أضف 2 هريس لحم)
- "بغيت 3 كبسة" → طلب (أضف 3 كبسة دجاج)

**⚠️ لا تستخدم هذه النية إذا:**
- العميل يسأل عن **توفر**: "عندكم هريس؟" → استخدم Ask Information
- العميل يسأل عن **سعر**: "كم سعر الهريس؟" → استخدم Ask Information
- العميل يسأل عن **وصف**: "ما هو الهريس؟" → استخدم Ask Information

**الإجراء:**
- أضف الصنف للطلب
- احسب المجموع
- اعرض ملخص الطلب
- اسأل إذا كان يريد إضافة المزيد
"""

result = supabase.table('prompt_sections').update({
    'content': new_order_items_update
}).eq('section_key', 'intent_new_order_items').execute()

if result.data:
    print("✅ تم تحديث New Order - Items")
else:
    print("❌ فشل تحديث New Order - Items")

# 3. Add clarification to system role
print("\n3️⃣ تحديث System Role...")

system_role_addition = """

**⚠️ مهم جداً - التمييز بين الاستفسار والطلب:**

1. **الاستفسار (Ask Information)**:
   - "عندكم X؟" → استفسار (أجب بنعم/لا + معلومات)
   - "كم سعر X؟" → استفسار (أعطِ السعر فقط)
   - "ما هو X؟" → استفسار (أعطِ الوصف فقط)
   
2. **الطلب (New Order - Items)**:
   - "أريد X" → طلب (أضف الصنف)
   - "أضف X" → طلب (أضف الصنف)
   - "طيب أريد X" → طلب (أضف الصنف)

**مثال:**
- ❌ خطأ: "عندكم هريس؟" → يضيف هريس للطلب
- ✅ صحيح: "عندكم هريس؟" → "نعم، عندنا هريس لحم بسعر 2.800 ر.ع. هل تريد طلبه؟"

**القاعدة الذهبية:**
- إذا كان السؤال يبدأ بـ "عندكم"، "كم سعر"، "ما هو" → استفسار (لا تضف للطلب)
- إذا كان السؤال يبدأ بـ "أريد"، "أضف"، "بغيت" → طلب (أضف للطلب)
"""

# Get current system role
result = supabase.table('prompt_sections').select('*').eq('section_key', 'system_role').execute()

if result.data:
    current_content = result.data[0]['content']
    
    # Check if already updated
    if 'التمييز بين الاستفسار والطلب' not in current_content:
        updated_content = current_content + system_role_addition
        
        result = supabase.table('prompt_sections').update({
            'content': updated_content
        }).eq('section_key', 'system_role').execute()
        
        if result.data:
            print("✅ تم تحديث System Role")
        else:
            print("❌ فشل تحديث System Role")
    else:
        print("⚠️ System Role محدث مسبقاً")
else:
    print("❌ لم يتم العثور على System Role")

print("\n" + "="*70)
print("✅ اكتمل التحديث!")
print("="*70)

print("""
الآن البوت يجب أن يميز بشكل أفضل بين:
- "عندكم هريس؟" → استفسار (يعطي معلومات فقط)
- "أريد هريس" → طلب (يضيف للطلب)

اختبر الآن:
1. "عندكم هريس؟" → يجب أن يجيب بمعلومات فقط
2. "طيب أريد 2 هريس لحم" → يجب أن يضيف للطلب
""")

