"""
Clear all conversation and order data from database
⚠️ WARNING: This will delete ALL data!
"""
import os
import sys
from pathlib import Path
from dotenv import load_dotenv
from supabase import create_client

# Load environment variables
env_path = Path(__file__).parent.parent / '.env'
load_dotenv(dotenv_path=env_path)

supabase = create_client(os.getenv('SUPABASE_URL'), os.getenv('SUPABASE_KEY'))

print("="*70)
print("⚠️  WARNING: DATABASE CLEANUP")
print("="*70)
print()
print("This will DELETE ALL:")
print("  • Conversation history")
print("  • Draft sessions")
print("  • Orders")
print("  • Order items")
print("  • Chats")
print()
print("⚠️  This action CANNOT be undone!")
print()

# Ask for confirmation
confirm = input("Type 'DELETE ALL' to confirm: ")

if confirm != "DELETE ALL":
    print("❌ Cancelled. No data was deleted.")
    sys.exit(0)

print()
print("="*70)
print("🗑️  Deleting data...")
print("="*70)
print()

try:
    # 1. Delete conversation history
    print("1️⃣ Deleting conversation history...")
    result = supabase.table('conversation_history').delete().neq('id', '00000000-0000-0000-0000-000000000000').execute()
    print(f"   ✅ Deleted {len(result.data) if result.data else 0} conversation records")
    
    # 2. Delete draft sessions
    print("2️⃣ Deleting draft sessions...")
    result = supabase.table('draft_sessions').delete().neq('id', '00000000-0000-0000-0000-000000000000').execute()
    print(f"   ✅ Deleted {len(result.data) if result.data else 0} draft sessions")
    
    # 3. Delete order items (must delete before orders due to foreign key)
    print("3️⃣ Deleting order items...")
    result = supabase.table('order_items').delete().neq('id', '00000000-0000-0000-0000-000000000000').execute()
    print(f"   ✅ Deleted {len(result.data) if result.data else 0} order items")
    
    # 4. Delete orders
    print("4️⃣ Deleting orders...")
    result = supabase.table('orders').delete().neq('id', '00000000-0000-0000-0000-000000000000').execute()
    print(f"   ✅ Deleted {len(result.data) if result.data else 0} orders")
    
    # 5. Delete chats
    print("5️⃣ Deleting chats...")
    result = supabase.table('chats').delete().neq('id', '00000000-0000-0000-0000-000000000000').execute()
    print(f"   ✅ Deleted {len(result.data) if result.data else 0} chats")
    
    print()
    print("="*70)
    print("✅ ALL DATA DELETED SUCCESSFULLY!")
    print("="*70)
    print()
    print("📊 Summary:")
    print("  • Conversation history: Cleared")
    print("  • Draft sessions: Cleared")
    print("  • Orders: Cleared")
    print("  • Order items: Cleared")
    print("  • Chats: Cleared")
    print()
    print("🎯 The bot will start fresh with new conversations!")
    print()
    
except Exception as e:
    print()
    print("="*70)
    print("❌ ERROR")
    print("="*70)
    print(f"Error: {e}")
    print()
    print("⚠️  Some data may have been deleted. Check the database.")
    sys.exit(1)

