"""
Check orders table schema
"""
import os
import sys
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from supabase import create_client
from dotenv import load_dotenv

load_dotenv()

supabase = create_client(
    os.getenv('SUPABASE_URL'),
    os.getenv('SUPABASE_KEY')
)

print("="*70)
print("  📊 CHECKING ORDERS TABLE SCHEMA")
print("="*70)

# Get one order to see all columns
try:
    result = supabase.table('orders').select('*').limit(1).execute()
    
    if result.data:
        order = result.data[0]
        print("\n✅ Orders table columns:")
        for key in sorted(order.keys()):
            value = order[key]
            value_type = type(value).__name__
            print(f"   - {key:30s} ({value_type})")
    else:
        print("\n⚠️ No orders found in table")
        
except Exception as e:
    print(f"\n❌ Error: {e}")

print("\n" + "="*70)
print("  📊 CHECKING ORDER_ITEMS TABLE SCHEMA")
print("="*70)

# Get one order_item to see all columns
try:
    result = supabase.table('order_items').select('*').limit(1).execute()
    
    if result.data:
        item = result.data[0]
        print("\n✅ Order_items table columns:")
        for key in sorted(item.keys()):
            value = item[key]
            value_type = type(value).__name__
            print(f"   - {key:30s} ({value_type})")
    else:
        print("\n⚠️ No order items found in table")
        
except Exception as e:
    print(f"\n❌ Error: {e}")
