"""
Check for 'nano' quantity issue in order_items
"""
import os
import sys
from pathlib import Path
from dotenv import load_dotenv
from supabase import create_client

# Load environment variables
env_path = Path(__file__).parent.parent / '.env'
load_dotenv(dotenv_path=env_path)

supabase = create_client(os.getenv('SUPABASE_URL'), os.getenv('SUPABASE_KEY'))

# Get latest order with items
orders = supabase.table('orders').select('id, order_id, status').order('created_at', desc=True).limit(1).execute()

if orders.data:
    order = orders.data[0]
    print(f"📦 Order: {order['order_id']}")
    print(f"   Status: {order['status']}")
    print(f"   ID: {order['id']}")
    
    # Get order items
    items = supabase.table('order_items').select('*, menu_items(name_ar)').eq('order_id', order['id']).execute()
    
    if items.data:
        print(f"\n📋 Order Items:")
        for item in items.data:
            print(f"   - {item.get('menu_items', {}).get('name_ar', 'Unknown')}")
            print(f"     qty: {item.get('qty')} (type: {type(item.get('qty')).__name__})")
            print(f"     unit_price_omr: {item.get('unit_price_omr')}")
            print()
    else:
        print("❌ No items found")
else:
    print("❌ No orders found")

