#!/usr/bin/env python3
"""
Script to check current menu data and structure
"""
from supabase import create_client
import json

# Supabase credentials
SUPABASE_URL = "https://yoeyovuanxrsdfgokfgh.supabase.co"
SUPABASE_KEY = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6InlvZXlvdnVhbnhyc2RmZ29rZmdoIiwicm9sZSI6ImFub24iLCJpYXQiOjE3NTc1OTYzMDMsImV4cCI6MjA3MzE3MjMwM30.WyBnhKcjtuhBScid_NZupqPUKXBV1vnWxn0HsPSOYzo"

supabase = create_client(SUPABASE_URL, SUPABASE_KEY)

# Get all menu items
result = supabase.table('menu_items').select('*').order('category').execute()

print('📊 Current Menu Items:')
print('='*100)

categories = {}
for item in result.data:
    cat = item.get('category', 'Unknown')
    if cat not in categories:
        categories[cat] = []
    categories[cat].append(item)

for category, items in sorted(categories.items(), key=lambda x: (x[0] is None, x[0])):
    cat_name = category if category else 'Unknown'
    print(f"\n🍽️  {cat_name} ({len(items)} items)")
    print('-'*100)
    for item in items:
        print(f"  Code: {item.get('code')}")
        print(f"    AR: {item.get('name_ar')}")
        print(f"    EN: {item.get('name_en')}")
        print(f"    Price: {item.get('price_omr')} OMR")
        print(f"    Description AR: {item.get('description_ar', 'N/A')}")
        print(f"    Description EN: {item.get('description_en', 'N/A')}")
        print(f"    Tags: {item.get('tags', 'N/A')}")
        print()

print(f'\n📈 Total Items: {len(result.data)}')
print(f'📂 Total Categories: {len(categories)}')

# Get table structure
if result.data:
    print('\n📋 Current Columns:')
    print('='*100)
    for key in sorted(result.data[0].keys()):
        sample_value = result.data[0].get(key)
        value_type = type(sample_value).__name__
        print(f"  - {key:20s} ({value_type})")

# Check for missing columns
print('\n🔍 Checking for required columns:')
print('='*100)
required_columns = ['description', 'tags', 'name_ar', 'name_en']
existing_columns = list(result.data[0].keys()) if result.data else []

for col in required_columns:
    if col in existing_columns:
        print(f"  ✅ {col} - EXISTS")
    else:
        print(f"  ❌ {col} - MISSING")

