#!/usr/bin/env python3
"""
تحليل أولوية النوايا في البوت
"""

import os
import sys
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

from supabase import create_client
from dotenv import load_dotenv

load_dotenv()

supabase = create_client(
    os.getenv('SUPABASE_URL'),
    os.getenv('SUPABASE_KEY')
)

print("="*70)
print("تحليل أولوية النوايا")
print("="*70)

# Get intents
result = supabase.table('prompt_sections').select('*').like('section_key', 'intent_%').execute()

print(f"\n📊 عدد النوايا: {len(result.data)}")
print("\n" + "="*70)
print("النوايا المتاحة:")
print("="*70)

for i, intent in enumerate(result.data, 1):
    key = intent['section_key']
    name = intent.get('section_name', 'N/A')
    order = intent.get('display_order', 999)
    
    print(f"{i:2d}. {key:40s} | Order: {order:3d} | {name}")

print("\n" + "="*70)
print("المشكلة المحتملة:")
print("="*70)

print("""
عندما يسأل العميل "عندكم هريس؟"، البوت يفسرها كـ:
- ❌ "New Order - Items" (إضافة صنف)
بدلاً من:
- ✅ "Ask Information" (استفسار عن معلومات)

السبب:
1. البوت في مرحلة 'items' (إضافة أصناف)
2. الـ Prompt يعطي أولوية لـ "New Order - Items" في هذه المرحلة
3. GPT يفسر "عندكم هريس" كطلب إضافة بدلاً من استفسار

الحلول الممكنة:
1. تحسين الـ Prompt لتوضيح الفرق بين الاستفسار والطلب
2. إضافة أمثلة أكثر وضوحاً في كل نية
3. تعديل ترتيب النوايا (display_order)
""")

print("\n" + "="*70)
print("الحل المقترح:")
print("="*70)

print("""
تحديث الـ Prompt لتوضيح:

**Ask Information (استفسار عن معلومات)**
- "عندكم هريس؟" → استفسار (يجيب بنعم/لا + معلومات)
- "كم سعر الهريس؟" → استفسار (يعطي السعر فقط)
- "ما هو الهريس؟" → استفسار (يعطي وصف)

**New Order - Items (إضافة أصناف)**
- "أريد هريس" → طلب (يضيف الصنف)
- "أضف هريس" → طلب (يضيف الصنف)
- "طيب أريد 2 هريس لحم" → طلب (يضيف الصنف)

الكلمات المفتاحية:
- استفسار: "عندكم"، "كم سعر"، "ما هو"، "هل يوجد"
- طلب: "أريد"، "أضف"، "طيب أريد"، "بغيت"
""")

print("\n" + "="*70)
print("✅ التحليل اكتمل")
print("="*70)

