#!/usr/bin/env python3
"""
Add send_location action to output_format prompt
"""

from supabase import create_client
from dotenv import load_dotenv
import os

load_dotenv()

supabase = create_client(os.getenv('SUPABASE_URL'), os.getenv('SUPABASE_KEY'))

# Get current output_format
result = supabase.table('prompt_sections').select('*').eq('section_key', 'output_format').execute()

if not result.data:
    print("❌ output_format not found")
    exit(1)

current_content = result.data[0]['content']

# Check if send_location already exists
if '"send_location"' in current_content:
    print("✅ send_location action already exists")
    exit(0)

# Add send_location to the list of actions
new_content = current_content.replace(
    '- `"collect_contact"` - جمع معلومات الاتصال',
    '- `"collect_contact"` - جمع معلومات الاتصال\n- `"send_location"` - إرسال موقع العميل (Location Message)'
)

# Update the prompt
supabase.table('prompt_sections').update({
    'content': new_content
}).eq('section_key', 'output_format').execute()

print("✅ Added send_location action to output_format")
print("\nNext: Update stage_management to use send_location in payment stage")

