#!/usr/bin/env python3
"""
Script to add description and tags columns directly using psycopg2
"""
import sys

try:
    import psycopg2
    from psycopg2 import sql
except ImportError:
    print("❌ psycopg2 not installed. Installing...")
    import subprocess
    subprocess.check_call([sys.executable, "-m", "pip", "install", "psycopg2-binary"])
    import psycopg2
    from psycopg2 import sql

# Supabase connection string
# Format: postgresql://postgres:[PASSWORD]@[HOST]:5432/postgres
CONNECTION_STRING = "postgresql://postgres.yoeyovuanxrsdfgokfgh:Aa123456789@aws-0-eu-central-1.pooler.supabase.com:6543/postgres"

print("🚀 Adding description and tags columns to menu_items table...")
print("="*100)

try:
    # Connect to database
    print("📡 Connecting to database...")
    conn = psycopg2.connect(CONNECTION_STRING)
    conn.autocommit = True
    cursor = conn.cursor()
    print("✅ Connected successfully")
    
    # Add description column
    print("\n1️⃣ Adding 'description' column...")
    try:
        cursor.execute("""
            ALTER TABLE menu_items 
            ADD COLUMN IF NOT EXISTS description TEXT;
        """)
        print("  ✅ Column 'description' added")
    except Exception as e:
        print(f"  ⚠️  {str(e)}")
    
    # Add tags column
    print("\n2️⃣ Adding 'tags' column...")
    try:
        cursor.execute("""
            ALTER TABLE menu_items 
            ADD COLUMN IF NOT EXISTS tags TEXT[];
        """)
        print("  ✅ Column 'tags' added")
    except Exception as e:
        print(f"  ⚠️  {str(e)}")
    
    # Create index on tags
    print("\n3️⃣ Creating index on 'tags'...")
    try:
        cursor.execute("""
            CREATE INDEX IF NOT EXISTS idx_menu_items_tags 
            ON menu_items USING GIN(tags);
        """)
        print("  ✅ Index created")
    except Exception as e:
        print(f"  ⚠️  {str(e)}")
    
    # Verify columns exist
    print("\n4️⃣ Verifying columns...")
    cursor.execute("""
        SELECT column_name, data_type 
        FROM information_schema.columns 
        WHERE table_name = 'menu_items'
        ORDER BY ordinal_position;
    """)
    
    columns = cursor.fetchall()
    print("\n📋 Current table structure:")
    for col_name, col_type in columns:
        print(f"  - {col_name:20s} ({col_type})")
    
    # Close connection
    cursor.close()
    conn.close()
    
    print("\n" + "="*100)
    print("✅ Columns added successfully!")
    print("\n📝 Next step: Run update_menu_schema.py to populate the data")
    
except psycopg2.Error as e:
    print(f"\n❌ Database error: {e}")
    print(f"   Code: {e.pgcode}")
    print(f"   Details: {e.pgerror}")
    sys.exit(1)
except Exception as e:
    print(f"\n❌ Error: {str(e)}")
    sys.exit(1)

