#!/usr/bin/env python3
"""
Script to add columns using Supabase Management API
"""
import requests
import json

# Supabase Project Details
PROJECT_REF = "yoeyovuanxrsdfgokfgh"
SUPABASE_URL = f"https://{PROJECT_REF}.supabase.co"
SERVICE_KEY = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6InlvZXlvdnVhbnhyc2RmZ29rZmdoIiwicm9sZSI6InNlcnZpY2Vfcm9sZSIsImlhdCI6MTc1NzU5NjMwMywiZXhwIjoyMDczMTcyMzAzfQ.RTTcsH5DHpElzwXCH-OPAVemW-yxgLF3VH0iBF9qkF4"

print("🚀 Adding columns to menu_items table via Supabase SQL Editor...")
print("="*100)

# SQL to execute
sql_commands = [
    "ALTER TABLE menu_items ADD COLUMN IF NOT EXISTS description TEXT;",
    "ALTER TABLE menu_items ADD COLUMN IF NOT EXISTS tags TEXT[];",
    "CREATE INDEX IF NOT EXISTS idx_menu_items_tags ON menu_items USING GIN(tags);",
]

# Try using the SQL endpoint
headers = {
    "apikey": SERVICE_KEY,
    "Authorization": f"Bearer {SERVICE_KEY}",
    "Content-Type": "application/json"
}

print("\n📝 Attempting to execute SQL commands...")
print("="*100)

for i, sql in enumerate(sql_commands, 1):
    print(f"\n[{i}/{len(sql_commands)}] {sql[:80]}...")
    
    # Try using RPC endpoint
    try:
        response = requests.post(
            f"{SUPABASE_URL}/rest/v1/rpc/exec_sql",
            headers=headers,
            json={"query": sql}
        )
        
        if response.status_code == 200:
            print(f"  ✅ Success")
        else:
            print(f"  ❌ Failed: {response.status_code} - {response.text[:100]}")
    except Exception as e:
        print(f"  ❌ Error: {str(e)[:100]}")

print("\n" + "="*100)
print("\n⚠️  Note: If the above failed, you need to run the SQL manually in Supabase Dashboard")
print("\n📋 Manual Steps:")
print("1. Go to: https://supabase.com/dashboard/project/yoeyovuanxrsdfgokfgh/editor")
print("2. Click on 'SQL Editor'")
print("3. Run the following SQL:")
print("\n" + "-"*100)
print("""
-- Add description column
ALTER TABLE menu_items ADD COLUMN IF NOT EXISTS description TEXT;

-- Add tags column  
ALTER TABLE menu_items ADD COLUMN IF NOT EXISTS tags TEXT[];

-- Create index on tags
CREATE INDEX IF NOT EXISTS idx_menu_items_tags ON menu_items USING GIN(tags);
""")
print("-"*100)
print("\n4. After running the SQL, execute: python3 scripts/update_menu_schema.py")

