#!/bin/bash

# Restaurant Chatbot Server - Run Script

echo "🚀 Starting Restaurant Chatbot Server..."
echo ""

# Check if virtual environment exists
if [ ! -d "venv" ]; then
    echo "❌ Virtual environment not found!"
    echo "Creating virtual environment..."
    python3 -m venv venv
    echo "✅ Virtual environment created"
    echo ""
fi

# Activate virtual environment
echo "Activating virtual environment..."
source venv/bin/activate

# Check if requirements are installed
if [ ! -f "venv/bin/uvicorn" ]; then
    echo "📦 Installing requirements..."
    pip install -r requirements.txt
    echo "✅ Requirements installed"
    echo ""
fi

# Check if .env exists
if [ ! -f ".env" ]; then
    echo "⚠️  .env file not found!"
    echo "Copying .env.example to .env..."
    cp .env.example .env
    echo "✅ Please edit .env file with your credentials"
    echo ""
    exit 1
fi

# Create logs directory if it doesn't exist
mkdir -p logs

# Run the server
echo "🎯 Starting server on http://0.0.0.0:8000"
echo "📝 Logs: logs/app.log"
echo ""
echo "Press Ctrl+C to stop"
echo ""

python app/main.py

