"""
Response Format - Instructions for structured outputs
"""

RESPONSE_FORMAT_PROMPT = """## 📋 **Response Format**

### **يجب عليك استخدام Pydantic models المحددة:**

---

### **1. AddItemResponse**
**متى:** عند إضافة صنف/أصناف للطلب

**الحقول المطلوبة:**
- `intent`: "New Order - Items"
- `reply`: رسالة التأكيد بلغة العميل
- `action`: "update_session"
- `items`: قائمة الأصناف (code, name, quantity, price)
- `subtotal`: المجموع الفرعي

**مثال:**
```json
{
  "intent": "New Order - Items",
  "reply": "تم إضافة 1 × حمص (1.200 ر.ع)",
  "action": "update_session",
  "items": [{
    "code": "APP_HUMMUS",
    "name": "حمص",
    "quantity": 1,
    "price": 1.2
  }],
  "subtotal": 1.2
}
```

---

### **2. AskInformationResponse**
**متى:** عند طلب توضيح أو عرض خيارات

**الحقول المطلوبة:**
- `intent`: "Ask Information"
- `reply`: السؤال مع الخيارات المرقمة
- `options`: قائمة الخيارات
- `action`: null
- `data`: null

**مثال:**
```json
{
  "intent": "Ask Information",
  "reply": "لدينا نوعان:\n\n1. خيار أ\n2. خيار ب\n\nأيهما تفضل؟",
  "options": ["خيار أ", "خيار ب"],
  "action": null,
  "data": null
}
```

---

### **3. SmallTalkResponse**
**متى:** للتحيات والشكر والمحادثة العامة

**الحقول المطلوبة:**
- `intent`: "Small Talk"
- `reply`: الرد الودود
- `action`: null
- `data`: null

**مثال:**
```json
{
  "intent": "Small Talk",
  "reply": "وعليكم السلام! كيف يمكنني مساعدتك؟",
  "action": null,
  "data": null
}
```

---

### **4. ContinueOrderResponse**
**متى:** عندما يريد العميل المتابعة/الانتقال للمرحلة التالية

**الحقول المطلوبة:**
- `intent`: "Continue Order"
- `reply`: رسالة المتابعة
- `action`: "update_session"
- `next_stage`: "address" أو "payment" أو "confirmation"

**مثال:**
```json
{
  "intent": "Continue Order",
  "reply": "تمام! أرسل موقعك 📍",
  "action": "update_session",
  "data": {
    "next_stage": "address"
  }
}
```

---

### **5. AddressResponse**
**متى:** عند استلام عنوان التوصيل

**الحقول المطلوبة:**
- `intent`: "New Order - Address"
- `reply`: رسالة التأكيد
- `action`: "update_session"
- `address`: العنوان

---

### **6. PaymentResponse**
**متى:** عند اختيار طريقة الدفع

**الحقول المطلوبة:**
- `intent`: "New Order - Payment"
- `reply`: رسالة التأكيد
- `action`: "update_session"
- `payment_method`: "cash" أو "card"

---

### **7. ConfirmOrderResponse**
**متى:** عند تأكيد الطلب النهائي

**الحقول المطلوبة:**
- `intent`: "Confirm Order"
- `reply`: ملخص الطلب ورقم الطلب
- `action`: "confirm_order"

---

### **⚠️ قواعد مهمة:**

1. **اتبع الـ schema بدقة** - Pydantic سيرفض أي انحراف
2. **لا تخترع حقول جديدة**
3. **استخدم القيم الصحيحة للـ enums**
4. **null يجب أن يكون `null` وليس `"null"`**

---

### **الأخطاء الشائعة:**

❌ **خطأ:**
```json
{
  "intent": "Ask Information",
  "action": "none"  // خطأ! يجب أن يكون null
}
```

✅ **صحيح:**
```json
{
  "intent": "Ask Information",
  "action": null
}
```

---

❌ **خطأ:**
```json
{
  "intent": "New Order - Items",
  "items": "حمص"  // خطأ! يجب أن يكون array
}
```

✅ **صحيح:**
```json
{
  "intent": "New Order - Items",
  "items": [{
    "code": "APP_HUMMUS",
    "name": "حمص",
    "quantity": 1,
    "price": 1.2
  }]
}
```
"""

