"""
Intent Types
أنواع النوايا المدعومة في النظام
"""

from enum import Enum


class IntentType(Enum):
    """أنواع النوايا"""
    
    # Basic intents
    GREETING = "greeting"
    GOODBYE = "goodbye"
    THANKS = "thanks"
    HELP = "help"
    CONTACT_SUPPORT = "contact_support"  # 🆕 التواصل مع خدمة العملاء
    FAQ_INFO = "faq_info"  # 🆕 أسئلة عامة (فروع، مواقع، أوقات عمل)
    
    # Confirmation intents
    CONFIRM = "confirm"
    REJECT = "reject"
    
    # Menu intents
    SHOW_MENU = "show_menu"
    ASK_MENU = "ask_menu"  # Alias for SHOW_MENU (used by intent_guard)
    ORDER_FOOD = "order_food"
    
    # Cart intents
    SHOW_CART = "show_cart"
    CLEAR_CART = "clear_cart"
    EDIT_ITEM = "edit_item"  # 🆕 تعديل صنف في السلة

    # Order intents
    COMPLETE_ORDER = "complete_order"
    TRACK_ORDER = "track_order"
    CANCEL_ORDER = "cancel_order"
    REORDER = "reorder"

    # Other
    UNKNOWN = "unknown"
    NUMBER_SELECTION = "number_selection"
    ADD_MORE = "add_more"

