"""
Intents Package - نظام النوايا الموحد
"""

from app.intents.definitions import IntentType, IntentDefinition, get_intent_definition, get_all_intents
from app.intents.classifier import intent_classifier
from app.intents.unified_classifier import unified_classifier
from app.intents.rules_loader import intent_rules_loader
from app.services.metrics_tracker import metrics_tracker
from app.utils.logger import app_logger as logger


def initialize_intent_system() -> bool:
    """
    تهيئة نظام النوايا الموحد

    Returns:
        True إذا نجحت التهيئة، False إذا فشلت
    """
    try:
        logger.info("🚀 Initializing Unified Intent System...")

        # 1. Initialize unified classifier (loads rules automatically)
        success = unified_classifier.initialize()

        if not success:
            logger.error("❌ Failed to initialize unified classifier")
            return False

        # 2. Log system stats
        stats = unified_classifier.get_stats()
        logger.info(
            f"✅ Intent System initialized successfully:\n"
            f"   - Rules loaded: {stats['total_rules']}\n"
            f"   - Intents covered: {stats['intents_covered']}\n"
            f"   - Keywords DB: {'✓' if stats['has_keywords_db'] else '✗'}\n"
            f"   - Examples DB: {'✓' if stats['has_examples_db'] else '✗'}"
        )

        return True

    except Exception as e:
        logger.error(f"❌ Error initializing intent system: {str(e)}")
        return False


__all__ = [
    'IntentType',
    'IntentDefinition',
    'get_intent_definition',
    'get_all_intents',
    'intent_classifier',
    'unified_classifier',
    'intent_rules_loader',
    'metrics_tracker',
    'initialize_intent_system'
]

