"""
Contact Support Handler
معالج التواصل مع خدمة العملاء
"""

from typing import Dict, Any, List, Optional
from app.handlers.base_handler import BaseIntentHandler
from app.intents.intent_types import IntentType
import logging

logger = logging.getLogger(__name__)


class ContactSupportHandler(BaseIntentHandler):
    """معالج طلبات التواصل مع خدمة العملاء"""

    @property
    def intent_type(self) -> IntentType:
        return IntentType.CONTACT_SUPPORT

    @property
    def prompt_template(self) -> str:
        """قالب الـ Prompt (غير مستخدم لأن الرد ثابت)"""
        return ""
    
    async def handle(
        self,
        user_message: str,
        context: Dict,
        conversation_history: Optional[List[Dict]] = None
    ) -> Dict:
        """
        معالجة طلب التواصل مع خدمة العملاء
        
        Args:
            user_message: رسالة المستخدم
            context: سياق المحادثة
            conversation_history: تاريخ المحادثة
            
        Returns:
            Dict: الرد على المستخدم
        """
        logger.info(f"📞 Contact support request from user")
        
        # رسالة الرد مع معلومات التواصل
        response = (
            "📞 **خدمة العملاء**\n\n"
            "يسعدنا خدمتك! يمكنك التواصل معنا عبر:\n\n"
            "📱 **الهاتف:**\n"
            "+968 9000 1234\n"
            "(متاح من 8 صباحاً - 11 مساءً)\n\n"
            "📧 **البريد الإلكتروني:**\n"
            "support@tasteoman.com\n\n"
            "💬 **واتساب:**\n"
            "+968 9000 1234\n\n"
            "🕐 **أوقات العمل:**\n"
            "السبت - الخميس: 8:00 ص - 11:00 م\n"
            "الجمعة: 2:00 م - 11:00 م\n\n"
            "نحن هنا لخدمتك دائماً! 🌟"
        )
        
        return {
            'intent': self.intent_type.value,
            'response': response,
            'action': None,
            'data': {}
        }

