# 🤖 Restaurant Chatbot Server

سيرفر مستقل بلغة Python لإدارة chatbot مطعم مع نظام برومبت ديناميكي.

## 🌟 المميزات

- ✅ **سيرفر مستقل** - يعمل بدون n8n
- ✅ **Python + FastAPI** - سريع وحديث
- ✅ **Evolution API** - اتصال مباشر مع WhatsApp
- ✅ **Supabase** - قاعدة بيانات سحابية
- ✅ **OpenAI GPT-4** - ذكاء اصطناعي متقدم
- ✅ **برومبت ديناميكي** - تحميل أقسام البرومبت حسب السياق
- ✅ **الرسائل الصوتية** - تحويل الصوت إلى نص باستخدام Whisper AI 🎤
- ✅ **توفير 75%** من التكلفة والوقت

---

## 📋 المتطلبات

- Python 3.10+
- Evolution API (مثبت ومشغل)
- Supabase Account
- OpenAI API Key

---

## 🚀 التثبيت

### 1. Clone المشروع

```bash
cd /Users/apple/Downloads/n8n/restaurant-chatbot-server
```

### 2. إنشاء بيئة افتراضية

```bash
python3 -m venv venv
source venv/bin/activate  # على Mac/Linux
# أو
venv\Scripts\activate  # على Windows
```

### 3. تثبيت المكتبات

```bash
pip install -r requirements.txt
```

### 4. إعداد ملف .env

```bash
cp .env.example .env
```

ثم عدّل ملف `.env` وأضف:

```env
# Supabase
SUPABASE_URL=https://yoeyovuanxrsdfgokfgh.supabase.co
SUPABASE_KEY=your_supabase_key_here

# OpenAI
OPENAI_API_KEY=your_openai_key_here

# Evolution API
EVOLUTION_API_URL=http://localhost:8080
EVOLUTION_API_KEY=your_evolution_key_here
EVOLUTION_INSTANCE_NAME=restaurant-bot
```

---

## 🏃 تشغيل السيرفر

### Development Mode (مع auto-reload)

```bash
python -m uvicorn app.main:app --reload --host 0.0.0.0 --port 8000
```

### Production Mode

```bash
python -m uvicorn app.main:app --host 0.0.0.0 --port 8000 --workers 4
```

أو ببساطة:

```bash
python app/main.py
```

---

## 🔗 ربط Evolution API

### 1. في Evolution API Dashboard:

```
Webhook URL: http://your-server-ip:8000/webhook/whatsapp
Events: messages.upsert
```

### 2. اختبار الاتصال:

```bash
curl http://localhost:8000/health
```

يجب أن ترى:

```json
{
  "status": "healthy",
  "timestamp": 1234567890.123,
  "environment": "development"
}
```

---

## 📡 API Endpoints

### الأساسية

| Endpoint | Method | الوصف |
|----------|--------|-------|
| `/` | GET | معلومات السيرفر |
| `/health` | GET | فحص الصحة |
| `/status` | GET | حالة الخدمات |
| `/config` | GET | الإعدادات (debug فقط) |

### Webhook

| Endpoint | Method | الوصف |
|----------|--------|-------|
| `/webhook/whatsapp` | POST | استقبال رسائل WhatsApp |
| `/webhook/health` | GET | فحص صحة Webhook |

---

## 🏗️ بنية المشروع

```
restaurant-chatbot-server/
├── app/
│   ├── __init__.py
│   ├── main.py                 # السيرفر الرئيسي
│   ├── config.py               # الإعدادات
│   ├── services/
│   │   ├── prompt_builder.py   # بناء البرومبت الديناميكي
│   │   ├── session_manager.py  # إدارة الجلسات
│   │   ├── order_manager.py    # إدارة الطلبات
│   │   ├── openai_service.py   # خدمة OpenAI
│   │   └── evolution_api.py    # خدمة Evolution API
│   ├── routes/
│   │   └── webhook.py          # مسارات Webhook
│   └── utils/
│       └── logger.py           # تسجيل الأحداث
├── requirements.txt
├── .env.example
└── README.md
```

---

## 🔄 كيف يعمل النظام؟

```
1. WhatsApp Message
   ↓
2. Evolution API Webhook
   ↓
3. FastAPI Server (/webhook/whatsapp)
   ↓
4. Get/Create Session (Supabase)
   ↓
5. Build Dynamic Prompt (حسب stage)
   ↓
6. Send to OpenAI GPT-4
   ↓
7. Parse AI Response (intent, action, data)
   ↓
8. Execute Action (update_session, create_order, etc.)
   ↓
9. Send Reply via Evolution API
   ↓
10. Customer receives message
```

---

## 📊 مثال على Flow

### 1. العميل يرسل: "أريد 2 هريس لحم"

```python
# السيرفر يستقبل الرسالة
→ POST /webhook/whatsapp

# يجلب/ينشئ Session
session = {
    "stage": "items",
    "items": [],
    "status": null
}

# يبني البرومبت الديناميكي
required_sections = [
    "system_role",
    "price_rule",
    "intent_new_order_items",
    "menu_items"
]

# يرسل لـ OpenAI
response = {
    "intent": "New Order - Items",
    "reply": "تم إضافة هريس لحم × 2 (5.600 OMR). ما عنوانك؟",
    "action": "update_session",
    "data": {
        "stage": "address",
        "items": [{"name": "هريس لحم", "quantity": 2, "price": 2.800}],
        "subtotal": 5.600
    }
}

# يحدث Session
# يرسل الرد للعميل
```

---

## 🧪 الاختبار

### اختبار يدوي:

```bash
# 1. تشغيل السيرفر
python app/main.py

# 2. في نافذة أخرى، أرسل رسالة تجريبية
curl -X POST http://localhost:8000/webhook/whatsapp \
  -H "Content-Type: application/json" \
  -d '{
    "event": "messages.upsert",
    "data": {
      "key": {
        "remoteJid": "96812345678@s.whatsapp.net",
        "fromMe": false,
        "id": "test123"
      },
      "message": {
        "conversation": "أريد 2 هريس لحم"
      }
    }
  }'
```

---

## 📝 Logs

الـ logs تُحفظ في:

```
logs/app.log
```

لمشاهدة الـ logs مباشرة:

```bash
tail -f logs/app.log
```

---

## 🐳 Docker (اختياري)

### إنشاء Dockerfile:

```dockerfile
FROM python:3.11-slim

WORKDIR /app

COPY requirements.txt .
RUN pip install --no-cache-dir -r requirements.txt

COPY app/ ./app/

EXPOSE 8000

CMD ["python", "-m", "uvicorn", "app.main:app", "--host", "0.0.0.0", "--port", "8000"]
```

### تشغيل:

```bash
docker build -t restaurant-chatbot .
docker run -p 8000:8000 --env-file .env restaurant-chatbot
```

---

## 🔒 الأمان

### في Production:

1. **استخدم HTTPS**
2. **أضف Webhook Secret**:
   ```python
   # في webhook.py
   if request.headers.get('X-Webhook-Secret') != settings.WEBHOOK_SECRET:
       raise HTTPException(401)
   ```
3. **حدد CORS**:
   ```python
   allow_origins=["https://yourdomain.com"]
   ```
4. **استخدم Rate Limiting**
5. **لا تعرض `/config` في production**

---

## 📈 المراقبة

### Metrics:

```bash
# عدد الرسائل المعالجة
grep "Processing message" logs/app.log | wc -l

# متوسط وقت الاستجابة
grep "← POST /webhook/whatsapp" logs/app.log
```

---

## 🆘 استكشاف الأخطاء

### المشكلة: السيرفر لا يستقبل رسائل

**الحل**:
1. تحقق من Evolution API webhook settings
2. تحقق من firewall
3. تحقق من logs: `tail -f logs/app.log`

### المشكلة: OpenAI يرجع خطأ

**الحل**:
1. تحقق من API Key
2. تحقق من حجم البرومبت
3. راجع logs

### المشكلة: Supabase connection error

**الحل**:
1. تحقق من SUPABASE_URL و SUPABASE_KEY
2. تحقق من الاتصال بالإنترنت
3. تحقق من Supabase Dashboard

---

## 🚀 النشر

### على VPS (Ubuntu):

```bash
# 1. تثبيت Python
sudo apt update
sudo apt install python3.11 python3.11-venv

# 2. Clone المشروع
git clone your-repo
cd restaurant-chatbot-server

# 3. إعداد البيئة
python3.11 -m venv venv
source venv/bin/activate
pip install -r requirements.txt

# 4. إعداد .env
nano .env

# 5. تشغيل مع systemd
sudo nano /etc/systemd/system/chatbot.service
```

**chatbot.service**:
```ini
[Unit]
Description=Restaurant Chatbot Server
After=network.target

[Service]
User=your-user
WorkingDirectory=/path/to/restaurant-chatbot-server
Environment="PATH=/path/to/venv/bin"
ExecStart=/path/to/venv/bin/python -m uvicorn app.main:app --host 0.0.0.0 --port 8000

[Install]
WantedBy=multi-user.target
```

```bash
sudo systemctl enable chatbot
sudo systemctl start chatbot
sudo systemctl status chatbot
```

---

## 🎤 الرسائل الصوتية (جديد!)

البوت يدعم الآن الرسائل الصوتية! يتم تحويل الصوت إلى نص تلقائياً باستخدام **OpenAI Whisper API**.

### ✨ الميزات:

- ✅ **تحويل تلقائي** من صوت إلى نص
- ✅ **دعم اللغة العربية** بشكل كامل
- ✅ **رسالة تأكيد** أثناء التحويل
- ✅ **معالجة ذكية** للنص المحول

### 📱 كيفية الاستخدام:

1. افتح WhatsApp
2. اضغط على أيقونة الميكروفون 🎤
3. سجل رسالة صوتية بالعربية
4. أرسل الرسالة
5. انتظر رسالة: "🎤 جاري تحويل الرسالة الصوتية إلى نص..."
6. استقبل الرد!

### 💰 التكلفة:

- **$0.006 لكل دقيقة**
- رسالة 10 ثوان = $0.001
- رسالة 1 دقيقة = $0.006

### 📚 المزيد من المعلومات:

راجع الدليل الكامل: [`docs/AUDIO_MESSAGES_GUIDE.md`](docs/AUDIO_MESSAGES_GUIDE.md)

---

## 📞 الدعم

للمساعدة أو الأسئلة، راجع:
- Logs: `logs/app.log`
- Status: `http://your-server:8000/status`
- Health: `http://your-server:8000/health`
- Audio Guide: `docs/AUDIO_MESSAGES_GUIDE.md`

---

**الإصدار**: 1.1.0
**الحالة**: ✅ جاهز للإنتاج
**آخر تحديث**: 2025-10-04 - إضافة دعم الرسائل الصوتية 🎤

